<?php
	//function for determining size of file upload max setting
	function DetermineSize($string, $error = '')
	{	
		if (empty($string)) {
			//there is no value - assume 2 Meg - send an error back
			$retVal = (((1024) * 1024) * 2);
		}
		else if (preg_match('/\d*KB?/i', $string)) {
			return ((1024) * intval($string));	
		}
		else if (preg_match('/\d*MB?/i', $string)) {
			return (((1024) * 1024) * intval($string));
		}
		else if (preg_match('/\d*GB?/i', $string)) {
			return ((((1024) * 1024) * 1024) * intval($string));	
		}
		else if (preg_match('/\d*TB?/i', $string)) {
			return ((((1024) * 1024) * 1024) * intval($string) * 1024);	
		}
		else if (preg_match('/\d+/', $string)) {
			return intval($string);	
		}
		
		$error = "Unable to Determine PHP Internal Limiter - Guessing 2MB";
		return $retVal;
	}
?>