<?php
	define("STORED_USER", 1);
	define("CUSTOM_TO", 0);
	
	/*
		7/22/06 Update:
	*/

	class Invoice
	{
		var $id;
		var $error = false;
		var $query = "";
		var $tickets = array();

		var $displayResolutions = false;
		var $group;
		var $title;
		var $to;
		var $saveMe = false;
		var $saveDate;
		
		var $dateStart;
		var $dateEnd;
		var $sortColumn;
		var $sortDirection;
		
		var $includeColumns = array( "name", "date", "descrip" );	// we have some default columns to show
		var $for = array();
		
		var $calcFinalTotal = false;
		var $oneTickPage = false;
		
		// Arrays for Holding Query Building Information
		var $joinTables = array();		// joined tables
		var $conditions = array();
		var $tables = array();			// included tables
		
		function Invoice($id = false)
		{
			if ($id) {
				$this->id = $id;
				$this->fetch();	
			}
		}
		
		function fetch()
		{
			// the name is the title
			$q = "select * from " . DB_PREFIX . "saved_invoices where id = " . $this->id;
			$s = mysql_query($q) or die(mysql_error());
			$r = mysql_fetch_assoc($s);
			
			// store the unserialized object
			$obj = unserialize(stripslashes($r['contents']));		// rebuild the object
			
			if ($obj)
			{
				// now reassign the parameters within to the new one
				// then set $obj to null to mark for gc
				$this->calcFinalTotal = $obj->calcFinalTotal;
				$this->conditions = $obj->conditions;
				$this->dateEnd = $obj->dateEnd;
				$this->dateStart = $obj->dateStart;
				$this->displayResolutions = $obj->displayResolutions;
				$this->error = $obj->error;
				$this->for = $obj->for;
				$this->group = $obj->group;
				
				$this->includeColumns = $obj->includeColumns;
				$this->joinTables = $obj->joinTables;
				$this->oneTickPage = $obj->oneTickPage;
				$this->sortColumn = $obj->sortColumn;
				$this->sortDirection = $obj->sortDirection;
				$this->query = $obj->query;
				$this->saveDate = $obj->saveDate;
				$this->saveMe = $obj->saveMe;
				$this->tables = $obj->tables;
				$this->tickets = $obj->tickets;
				$this->title = $obj->title;
				$this->to = $obj->to;
			}
			
			$obj = null;
		}
		
		// functions for data sets
		
		function setStoredTo( $val )
		{
			if (intval($val) <= 0) {
				$this->error = true;
				return 'Invalid User ID Passed';
			}
			
			$user = new User(intval($val));
			if ($user->get('id') <= 0 ) {
				$this->error = true;
				return 'You Specified an Invalid User';
			}
			
			$this->to  = $user->get('LastName', 'stripslashes') . ", " . $user->get('FirstName', 'stripslashes') . "<br/>\n";
			$this->to .= $user->get('email_addr') . " - " . $user->get('phoneNumber', 'formatPhone') . " " . (($user->get('phoneExt', 'intval') > 0) ? " ext " . $user->get('phoneExt', 'intval') : '');
			return '';
		}
		
		function setCustomTo( $val)
		{
			if (empty($val)) {
				$this->error = true;
				return 'Please Provide a Custom To Label';
			}
			$this->to = $val;
			return '';
		}
		
		function setTitle( $val )
		{
			if (empty($val)) {
				$this->error = true;
				return 'Please Provide a Title';
			}
			$this->title = $val;
			return '';
		}
		
		function setGroup( $val )
		{
			if (empty($val)) {
				$this->error = true;
				return 'Please Select a Group';
			}
			
			switch ($val)
			{
				case 'priority':
				case 'user':
				case 'tickID':
					break;
				default:
					$this->error = true;
					return 'Invalid Grouping Specified';
			}
			
			$this->group = $val;
			return '';
		}
		
		function setDateStart( $val )
		{
			if (empty($val)) {
				$this->error = true;
				return 'Please Enter a Date Start Value';
			}
			
			@$val = strtotime($val, time());
			if ($val)
				$this->dateStart = $val;
			else {
				$this->error = true;
				return 'Unable to Read Date - Please Use format mm/dd/yyyy';
			}
			return '';
		}
		
		function setDateEnd( $val )
		{
			if (empty($val)) {
				$this->error = true;
				return 'Please Enter a Date End Value';
			}
			
			@$val = strtotime($val, time());
			if ($val)
				$this->dateEnd = $val;
			else {
				$this->true;
				return 'Unable to Read Date - Please Use format mm/dd/yyyy';
			}
			return '';
		}
		
		function validateDates()
		{
			if ($this->dateStart > $this->dateEnd) return 'Invalid Dates Specified - Start Must come Before End';
			return '';
		}
		
		function setSortColumn( $val )
		{
			$this->sortColumn = $val;
		}
		
		function setSortDirection( $val )
		{
			$this->sortDirection = $val;
		}
		
		function setIncludeColumns( $array = array() )
		{
			/*if (!count($array) || */
			if (!is_array($array)) {
				$this->error = true;
				return 'Invalid Data Detected - Please ReSubmit';
			}
			
			foreach ($array as $k => $v)
			{
				array_push($this->includeColumns, $v);
				//$this->includeColumns = $array;
			}
			return '';
		}
		
		/*
			we dont care if its empty as they signifies we want to use all values in the table
		*/
		function setForValue( $array = array() )
		{
			if (!is_array($array)) {
				$this->error = true;
				return 'Invalid Data Passed';
			}
			
			$this->for = $array;
			return '';
		}
		
		function setTicketArray( $array = array() )
		{
			if (!count($array) || !is_array($array)) {
				$this->error = true;
				return 'Please Provide a List of Tickets';
			}
			
			// make sure that the one entry is not a blank
			// we know at this point it must be an array
			if (empty($array[0]))
				return 'Please Provide a List of Tickets';
				
			$array = array_map('intval', $array);		// this makes sure that all entries are in fact numbers
			
			$this->tickets = $array;
			return '';
		}
		
		function setCalcFinalTotalOption( $val )
		{
			$this->calcFinalTotal = $val;
			if ($val)
				// by storing the cost in the include stack, it make it easier to work with
				array_push($this->includeColumns, 'cost');
		}
		
		function setOneTickPerPage( $val )
		{
			$this->oneTickPage = $val;
		}
		
		function setSave( $val )
		{
			$this->saveMe = $val;
		}
		
		// get functions
		function getResolutions($id)
		{
			$q = "select solution, resdate from " . DB_PREFIX . "resolution where id = $id";
			$s = mysql_query($q) or die(mysql_error());
			$return = array();
			
			while ($r = mysql_fetch_assoc($s))
			{
				$arr = array(
					'solution' 	=> nl2br($r['solution']),
					'date'		=> $r['resdate']
				);
				$return[] = $arr;
			}
			return $return;
		}
		
		// query generation
		function generateQuery()
		{
			// first we need to start the query - this is basic
			$this->query = "select d.id, ";
			
			// get the list of columns that we are going to display
			$columns = $this->parseIncludeColumns();
			
			// determine sorting
			$sort = "order by " . $this->generateSort();
			
			// determine our filtering parameters
			$conditions = $this->buildConditions();
			
			// now finally we build the tables - by calliung this last, we ensure that all
			// data has the support needed from the database
			$tables = "from " . DB_PREFIX . "data d " . $this->buildJoins() . $this->getIncludedTables();
			
			$this->query .= "$columns $tables $conditions $sort";
			
			return $this->query;
		}
			
		// Use this method for genearting the query when tickID option is asked for. THe parameter will be the list of ticket
		// IDs in Array form that we will use for hte where condition
		// in progress
		function generateTicketQuery( $tickets = array() )
		{
			$this->query = "select d.id, ";
			$columns = $this->parseIncludeColumns();
			
			// determine the ticket list
			$conditions = "";
			if (count($tickets) == 1) {
				$str = "d.id = " . $tickets[0];
				$conditions = "where ($str)";
			}
			elseif (count($tickets) > 1)
			{	
				$str = "d.id = " . implode(" or d.id = ", $tickets);	// add the rest on to the string
				$conditions = "where ($str)";
			}
			
			// build the output
			$tables = "from " . DB_PREFIX . "data d " . $this->buildJoins() . $this->getIncludedTables();
			
			$this->query .= "$columns $tables $conditions";
			return $this->query;
		}
		
		function generateSort()
		{
			switch ($this->sortColumn)
			{
				case 'staff':
					$this->defineTable('accounts', DB_PREFIX . 'accounts', 'a');
					return "a.LastName, a.FirstName " . $this->sortDirection;
				case 'name':
					return "d.LastName, d.FirstName " . $this->sortDirection;
				case 'cat':
					$this->defineTable('categories', DB_PREFIX . 'categories', 'c');
					return "c.name " . $this->sortDirection;
				case 'date':
					return "d.mainDate " . $this->sortDirection;
				case 'priority':
					$this->defineTable('priorities', DB_PREFIX . 'priorities', 'p');
					return "p.severity " . $this->sortDirection;
			}
		}
		
		function buildJoins()
		{
			/*
				In order for the query to return the results as we intend we must left join all support tables
				this is the reason for commenting out all filtering conditions, there are taken of here
			*/
			$retVal = "";
			foreach ($this->joinTables as $key => $arr)
			{
				$retVal .= "left join " . $arr['tableDef'] . " on " . $arr['condition'] . " ";
			}
			$retVal = preg_replace('/ $/', '', $retVal);
			return $retVal;
		}
		
		function buildConditions()
		{	
			// this gives us another level of filtering so we only get tickets for a certain condition
			array_push($this->conditions, 'd.mainDate between ' . $this->dateStart . ' and ' . $this->dateEnd);
			
			if (count($this->for)) {
				// we know we have for values - so now we need to see which kind we are using
				// also make sure the tables are included
				$arr = array();
				$type = $this->group != 'priority' ? 'd.regUser' : 'd.priority';
				foreach ( $this->for as $value )
					array_push($arr, $type ." = " . $value);
					
				array_push($this->conditions, "(" . implode(' or ', $arr) . ")");
			}
			
			return "where (" . implode(' and ', $this->conditions) . ")";
		}
		
		function parseIncludeColumns()
		{
			/*
				special detection here will have us add to the join array
			*/
			$retVal = "";
			foreach ($this->includeColumns as $k => $v)
			{
				// $k is not used
				switch ($v)
				{
					case 'name':
						// no join
						$retVal .= "concat(d.LastName, ', ', d.FirstName) as name, ";
						break;
					case 'date':
						// no join
						$retVal .= "date_format(from_unixtime(d.mainDate), '%b/%e/%Y') as mainDate, ";
						break;
					case 'resol':
						$this->displayResolutions = true;
						break;
					case 'category':
						$retVal .= "c.name as category, ";
						$this->defineJoin('categories', DB_PREFIX . 'categories c', 'd.category = c.id');
						break;
					case 'priority':
						$retVal .= "p.priority as priority, ";
						$this->defineJoin('priorities', DB_PREFIX . 'priorities p', 'd.priority = p.pid');
						break;
					case 'phone':
						// no join
						$retVal .= "d.phoneNumber, d.phoneExt, ";
						break;
					case 'staff':
						$retVal .= "a.User as staff, ";
						$this->defineJoin('accounts', DB_PREFIX . 'accounts a', 'd.staff = a.id');
						break;
					default:
						$retVal .= "d." . $v . ", ";
						break;
						
				}
			}
			$retVal = preg_replace('/, $/', '', $retVal);
			return $retVal . " ";
		}
		
		function defineJoin($key, $tableDef, $condition)
		{
			$arr = array(
				'tableDef' => $tableDef,
				'condition' => $condition
			);
			$this->joinTables[$key] = $arr;
			
			if (array_key_exists($key, $this->tables))
			{
				unset($this->tables[$key]);
			}
		}
		
		function defineTable($key, $table, $alias)
		{
			if (!array_key_exists($key, $this->tables) && !array_key_exists($key, $this->joinTables))
			{
				$arr = array(
					'table' => $table,
					'alias' => $alias,
				);
				$this->tables[$key] =  $arr;
			}
		}
		
		function getIncludedTables()
		{
			$retVal = "";
			if (count($this->tables))
			{
				$retVal .= ", ";
				foreach ($this->tables as $key => $value)
				{
					$retVal .= $value['table'] . " " . $value['alias'] . ", ";
				}
				$retVal = preg_replace('/, $/', '', $retVal);
			}
			return $retVal;
		}
		
		// the save function - save the object serialized
		function save()
		{
			$cmd = "insert into " . DB_PREFIX . "saved_invoices(name, contents, posted) values('" . mysql_real_escape_string($this->title) . "', '" . mysql_real_escape_string(serialize($this)) . "', " . time() . ")";
			mysql_query($cmd) or die(mysql_error());
			
			$this->id = mysql_insert_id();
		}
		
		// update - resave the object serialized
		function update()
		{
			$cmd = "update " . DB_PREFIX . "saved_invoices set ";
			$cmd .= "name = '" . mysql_real_escape_string($this->title) . "', ";
			$cmd .= "contents = '" . mysql_real_escape_string(serialize($this)) . "', ";
			$cmd .= "posted = " . time() . " ";
			$cmd .= "where id = " . intval($this->id);
			
			mysql_query($cmd) or die(mysql_error());
		}
		
		// delete - remove the object from the database
		function delete()
		{
			$cmd = "delete from " . DB_PREFIX . "saved_invoices where id = " . $this->id;
			if (mysql_query($cmd))			
				return true;
			else 
				return false;
		}
	}
	
	function formatPhone($input)
	{
		if (intval($input) <= 0) return 'Unknown';
		return substr($input, 0, 3) . "-" . substr($input, 3, 3) . "-" . substr($input, 6);
	}
?>