<?php
	/* 
			this page will eventually output a list of all the tickets to display with checkboxes. We want to allow the user
			to select the tickets he/she wishes to show. by default all the tickets displayed will be checked as this is
			likely the most common function request.
			
			our goal for this page is to be able to send the ticket IDs we want to retrieve. Since we will serialize the invoice
			class and send it in the session, we wil also have a listing of our columns.  We will basically execute the same
			query, but use the ticket ids from the checkboxes as a filtering mechanism, initally it will be put in the application
			though in time we could use it to generate SQL
	*/
	
	// first we need an SQL Statement and this is dependant on the type of invoce being created
	// this is a preview page for ticket selection
	
	// if their is no session data for invoice - generate the query
	// the session data will be created at the end of this page
	// otherwise pull the query from the invoice object directly as it will have been unserialized above
	if (!isset($_SESSION['invoiceData']))
	{
		var_dump($invoice->group);
		if ($invoice->group == 'tickID')
		{
			$q = $invoice->generateTicketQuery( explode(',', $_POST['txtTicks']) );
		}
		else
			$q = $invoice->generateQuery();
	}
	else
		$q = $invoice->query;
		
	//var_dump($q);
?>
<table cellpadding="0" cellspacing="0" border="0" width="55%">
<input type="hidden" name="display" value="1" />
	<?php
		$s = mysql_query($q) or die(mysql_error());
		if (mysql_num_rows($s))
		{
?>
	<tr><td colspan="2" style="padding-left: 10px" class="error">
	<?php
			if (isset($error_msg)) {
				echo $error_msg;
			}
	?>
	</td></tr>
	<tr><td colspan="2">
		<b>To: </b><br/><?php echo nl2br($invoice->to); ?><br/>
		<br/>
		<b>Title:</b><br/><?php echo $invoice->title; ?><br/>
	</td></tr>
<?php
			$totalCost = 0.00;
			while ($r = mysql_fetch_assoc($s))
			{
	?>
	<tr><td valign="top" style="background-color: #eeeeee; padding: 2px;" colspan="2">
		<input type="checkbox" name="tickets[<?php echo $r['id']; ?>]" value="1" <?php echo !isset($_POST['tickets']) || isset($_POST['tickets'][$r['id']]) ? 'checked="checked' : ''; ?>" />Use this Entry
	</td></tr>
	<tr>
		<th width="50%" align="left">Creator: <?php echo $r['name']; ?></th>
		<td width="50%" align="right">Created On: <?php echo $r['mainDate']; ?></td>
	</tr>
	<tr>
		<td valign="top" colspan="2">
			<hr/>
			<b>Ticket Description:</b><br/>
			<?php echo nl2br($r['descrip']); ?>
			<p></p>
			<?php
				/*
					It follows naturally that the resolutions should follow the description, so here we will do that.
					We have a member in the invoice class that tells us whether to call for resolutions.  We pass it
					the id of the ticket we are viewing
				*/
				if ($invoice->displayResolutions)
				{
			?>
			<b>Ticket Resolutions:</b><br/>
			<?php
					$data = $invoice->getResolutions( $r['id'] );
					if (count($data))
					{
						foreach ( $data as $arr )
						{
			?>
			<?php echo nl2br($arr['solution']); ?> - <?php echo $arr['resdate']; ?>
			<?php
						}
					}
			?>
				No Resolutions
			<?php
				}
			?>
			<p></p>
			<?php
			
				/*
					This is a listing of the possible columns well see in this result set.
				*/
				foreach ($r as $k => $v)
				{
					switch ($k)
					{
						case 'staff':
							/* simple print out */
							echo "<b>Assigned Staff: </b>" . printValue($v) . "<p></p>\n\n";
							break;
						case 'email':
							/* simple print out */
							echo "<b>Creator Email Address: </b>" . printValue($v) . "<p></p>\n\n";
							break;
						case 'phoneNumber':
							$phone = '';
							if (strlen($v)) {
								/* format */
								$phone = formatPhone($v);
								
								/* addin: ext display */
								if (strlen($r['phoneExt'])) { // notice how we dont define a case for phoneExt, it is handled here
									$phone .= " ext. " . $r['phoneExt'];
								}
							}
							echo "<b>Creator Phone Number: </b>" . printValue($phone) . "<p></p>\n\n";
							break;
						case 'category':
							/* simple print out */
							echo "<b>Ticket Category: </b>" . printValue($v) . "<p></p>\n\n";
							break;
						case 'priority':
							/* simple print out */
							echo "<b>Ticket Priority: </b>" . $v . "<p></p>\n\n";
							break;
						case 'cost':
							echo "<b>Ticket Cost: </b>$" . $v . "<p></p>\n\n";
							$totalCost += $v;
							break;
					}
				}
			?>
		</td>
	</tr>
	<tr><td height="7" colspan="2">
		<hr/>
	</td></tr>
	<?php
			}
	?>
	<?php
		if ($invoice->calcFinalTotal) {
	?>
	<tr>
		<th align="left">
			Total Ticket Cost:
		</th>
		<td align="right">
			<?php echo sprintf("$%.2f", $totalCost); ?><br/>
		</td>
	</tr>
	<?php
		}
	?>
	<?php
			if ($invoice->oneTickPage) {
	?>
	<tr><td colspan="2" style="color: red; font-weight: bold;">
		Display One Ticket per Page<br/>Closing Information on Final Page
	</td></tr>
	<?php
			}
			
			if ($invoice->saveMe) {
	?>
	<tr><td colspan="2" style="color: red; font-weight: bold;">
		Saving Invoice to Database
	</td></tr>
	<?php		// this is where we will save the information
				if (isset($_POST['btnDisplay'])) {
					if (isset($_POST['id'])) {
						$invoice->update();
					}
					else {
						$invoice->save();
					}
				}
			}
	?>
	<tr><td colspan="2" align="center">
		<input type="submit" name="btnDisplay" value="Display Invoice" />&nbsp;
		<?php
			if (isset($_POST['btnDisplay'])) {
				// we want to make sure that we displayed it at least once through the common method
		?><input type="button" value="ReOpen Invoice Window" onclick="showInvoiceInWindow( 1 );" /><?php
			}
		?>
	</td></tr>
	<?php if ($invoice->id > 0) {?>
	<input type="hidden" name="id" value="<?php echo $invoice->id; ?>" />
	<?php 	}
		}
		else 
		{
	?>
	<tr><th align="center">No Matching Rows Found</th></tr>
	<?php
		}
		$_SESSION['invoiceData'] = serialize($invoice);	// wrap it up so JS can use it
	?>
</form>
</table>